/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8224;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDialog;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8224.BoxInfo;
import ibm.nways.jdm8224.eui.AlternateConfigurationFolderGroup;
import ibm.nways.jdm8224.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8224.eui.FaultGroup;
import ibm.nways.jdm8224.eui.SecurityGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.util.ResourceBundle;

public class Jdm8224
extends JdmBrowser {
    private static final int RASID = 19;
    private static final int RASSUB = 1;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    private BoxInfo boxInfo;
    private static String bundleName = "ibm.nways.jdm8224.Resources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private NavFieldOverride jdm8224DeviceOverrides;
    static final Object[][] jdm8224DeviceFieldOverrides = new Object[][]{{"ibm.nways.mib2.model.System.Panel.SysDescr.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysContact.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysName.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysLocation.length", "48"}, {"ibm.nways.mib2.model.IpParam.Panel.IpDefaultTTL.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IfDescr.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteProto.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteInfo.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpForwarding.access", "read-only"}, {"ibm.nways.mib2.eui.Mib2InterfacesPanel.rfc1573.visible", "false"}};
    static final Object[][] modelxxx1Overrides = new Object[0][];

    public String getModelTypeName() {
        return "ibm.nways.jdm8224.model.Jdm8224";
    }

    public Dimension getDefaultSize() {
        Dimension dimension = new Dimension(1200, 800);
        return dimension;
    }

    protected NavigationPoint getNavTreeRoot() {
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, (Object)this, "getNavTreeRoot");
        }
        if (this.deviceModel != null || this.boxInfo != null) {
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, (Object)this, "getNavTreeRoot", "redraw request but still need to call dispose");
            }
            this.dispose();
        }
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, (Object)this, "getNavTreeRoot", "deviceModel is null!!!");
            }
            this.rootFolder = new NavigationFolder(Jdm8224.getNLSString("unknown"));
            this.navContext = this.rootFolder.getNavContext();
            return this.rootFolder;
        }
        this.displayMsg(Jdm8224.getNLSString("startBoxInfo"));
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        this.displayMsg(Jdm8224.getNLSString("endBoxInfo"));
        this.rootFolder = this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 5 ? new NavigationFolder(Jdm8224.getNLSString("deviceName")) : new NavigationFolder(Jdm8224.getNLSString("unknown"));
        this.navContext = this.rootFolder.getNavContext();
        BoxInfo.setInNavContext(this.navContext, this.boxInfo);
        this.jdm8224DeviceOverrides = new NavFieldOverride(this.navContext, jdm8224DeviceFieldOverrides);
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, (Object)this, "getNavTreeRoot");
        }
        return this.rootFolder;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, (Object)this, "getDeviceGraphicPanel");
        }
        GraphicPanel graphicPanel = null;
        long l = System.currentTimeMillis();
        this.displayMsg(Jdm8224.getNLSString("startDeviceGraphic"));
        if (this.deviceModel != null) {
            graphicPanel = this.boxInfo.getDeviceGraphic();
        } else {
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, (Object)this, "getDeviceGraphicPanel", "Cannot Draw Graphic - deviceModel null");
            }
            GraphicContainer graphicContainer = new GraphicContainer();
            Label label = new Label(Jdm8224.getNLSString("NoGraphic"), 1);
            label.setFont(new Font("Arial", 1, 14));
            label.setLocation(new Point(35, -5));
            graphicContainer.add(label);
            graphicPanel = new GraphicPanel((GraphicHandler)this, (Component)graphicContainer);
        }
        this.displayMsg(Jdm8224.getNLSString("endDeviceGraphic"));
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 1)) {
            RAS.trace(19, 1, (Object)this, "getDeviceGraphicPanel", "Finished device picture in " + String.valueOf(l2 - l) + " msecs");
        }
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, (Object)this, "getDeviceGraphicPanel");
        }
        return graphicPanel;
    }

    protected void getRestOfNavTree() {
        ConfigurationFolderGroup configurationFolderGroup;
        GenModel genModel;
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, (Object)this, "getRestOfNavTree");
        }
        this.displayMsg(Jdm8224.getNLSString("startTree"));
        NavigationFolder cfr_ignored_0 = (NavigationFolder)this.getNavigationTree();
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.rootFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        try {
            if (this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 5) {
                genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
                configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
                configurationFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
                this.rootFolder.add((NavigationPoint)configurationFolderGroup);
            } else {
                genModel = (GenModel)this.deviceModel.getComponent("AlternateConfigurationFolder");
                configurationFolderGroup = new AlternateConfigurationFolderGroup((JdmBrowser)this, genModel);
                configurationFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
                this.rootFolder.add((NavigationPoint)configurationFolderGroup);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1, (Object)this, "getRestOfNavTree", exception);
        }
        try {
            if (this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 5) {
                genModel = (GenModel)this.deviceModel.getComponent("Fault");
                configurationFolderGroup = new FaultGroup((JdmBrowser)this, genModel);
                configurationFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
                this.rootFolder.add((NavigationPoint)configurationFolderGroup);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1, (Object)this, "getRestOfNavTree", exception);
        }
        try {
            if (this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 5) {
                genModel = (GenModel)this.deviceModel.getComponent("Security");
                configurationFolderGroup = new SecurityGroup((JdmBrowser)this, genModel);
                configurationFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
                this.rootFolder.add((NavigationPoint)configurationFolderGroup);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1, (Object)this, "getRestOfNavTree", exception);
        }
        this.buildToolsFolder(this.rootFolder);
        this.displayMsg(Jdm8224.getNLSString("endTree"));
        if (this.boxInfo.getDeviceStatus() == 5) {
            this.displayMsg(Jdm8224.getNLSString("SlaveBoxMsg1"));
            genModel = new MessageDialog(this.getFrame(), Jdm8224.getNLSString("SlaveBoxMsg2"), true);
            ((Dialog)((Object)genModel)).setTitle(JdmBrowser.getJdmBrowserResource((String)"SlaveBoxTitle"));
            ((Dialog)((Object)genModel)).show();
        }
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, (Object)this, "getRestOfNavTree");
        }
    }

    public void dispose() {
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, (Object)this, "dispose");
        }
        if (this.boxInfo != null) {
            this.boxInfo.dispose();
            this.boxInfo = null;
        }
        this.rootFolder = null;
        this.tree = null;
        this.navContext = null;
        this.deviceModel = null;
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, (Object)this, "dispose");
        }
    }

    protected static String getNLSString(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                string2 = myResources.getString(string);
            }
            catch (Exception exception) {
                RAS.logException(19, 1, exception.getClass(), "getNLSString", exception);
                try {
                    string2 = commonResources.getString(string);
                }
                catch (Exception exception2) {
                    string2 = string;
                    if (!RAS.isEnabled(19, 1)) break block4;
                    RAS.trace(19, 1, exception2.getClass(), "getNLSString", "result string is" + string);
                }
            }
        }
        return string2;
    }

    public void buildToolsFolder(NavigationFolder navigationFolder) {
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, (Object)this, "buildToolsFolder");
        }
        NavigationFolder navigationFolder2 = new NavigationFolder(Jdm8224.getNLSString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(Jdm8224.getNLSString("mibBrowser"), (JdmBrowser)this, snmpContextModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            WebContext webContext = new WebContext(string);
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
            webContext.only_nhd_url();
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem3.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem3);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1, (Object)this, "buildToolsFolder", exception);
            exception.printStackTrace();
        }
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add((NavigationPoint)navigationFolder2);
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, (Object)this, "buildToolsFolder");
        }
    }
}

